/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.util.ArrayList;

public class Pair {
    private final ArrayList<Couple> items = new ArrayList();
    private final ArrayList<Couple> attributes = new ArrayList();

    public boolean sameAttributes(Pair p2) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (this.attributes.get(i).value == p2.attributes.get(i).value) continue;
            return false;
        }
        return true;
    }

    public int getAttributesSize() {
        int res = 0;
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (this.attributes.get(i).value == 0.0f) continue;
            ++res;
        }
        return res;
    }

    public void addItem(String name, float value) {
        this.items.add(new Couple(name, value));
    }

    public void addAttribute(String name, float value) {
        this.attributes.add(new Couple(name, value));
    }

    public String toString() {
        int i;
        String result = "<{";
        for (i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i).value == 0.0f) continue;
            result = result + this.items.get(i).toString() + ", ";
        }
        result = (result.endsWith(", ") ? result.substring(0, result.length() - 2) : result) + "}, {";
        for (i = 0; i < this.attributes.size(); ++i) {
            if (this.attributes.get(i).value == 0.0f) continue;
            result = result + this.attributes.get(i).toString() + ", ";
        }
        result = (result.endsWith(", ") ? result.substring(0, result.length() - 2) : result) + "}>";
        return result;
    }

    public boolean includes(Pair label) {
        if (this.items.containsAll(label.items) && label.items.containsAll(this.items)) {
            return false;
        }
        for (int i = 0; i < label.items.size(); ++i) {
            for (int j = 0; j < this.items.size(); ++j) {
                if (!label.items.get(i).name.equals(label.items.get(j).name) || !label.items.get(i).greater(this.items.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean emptyDifference(Pair label) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!(this.items.get(i).value > label.items.get(i).value)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(String s) {
        int i;
        for (i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).name.equals(s) || !(this.items.get(i).value > 0.0f)) continue;
            return true;
        }
        for (i = 0; i < this.attributes.size(); ++i) {
            if (!this.attributes.get(i).name.equals(s) || !(this.attributes.get(i).value > 0.0f)) continue;
            return true;
        }
        return false;
    }

    private class Couple
    implements Comparable {
        private final String name;
        private final float value;

        public Couple(String name, float value) {
            this.name = name;
            this.value = value;
        }

        public int compareTo(Object o) {
            Couple c = (Couple)o;
            return this.name.compareTo(c.name);
        }

        public String toString() {
            return this.value == 1.0f ? this.name : this.value + "/" + this.name;
        }

        public boolean greater(Couple c) {
            return this.value > c.value;
        }
    }
}

